#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
#include "report/brRunner.h"

#include "ctrl/BOLTReport.h"

#include "BOLTFrm.h"
#include "math.h"
BOLTReport::BOLTReport(RECORD_ID reportId,brRunner *runner,int p,wxString title):wxPrintout(title)
{
	this->reportPage=p;
	this->runner=runner;
	this->reportId=reportId;
	int t;
	GetPPIScreen(&(runner->ScreenPPI),&t);
//	this->tBitmap=NULL;
};

bool BOLTReport::HasPage(int page){
/*	int pixW,pixH;
	double pW,pH;
	double rW,rH;
	int pages,pagesWide,pagesHigh;

	rW=this->runner->db->GetFValue("reportLayouts","width",reportId);
	rH=this->runner->db->GetFValue("reportLayouts","height",reportId);

	int ppiW,ppiH;
	GetPageSizePixels(&pixW,&pixH);
	GetPPIPrinter(&ppiW,&ppiH);

	pW=(double)pixW/(double)ppiW;
	pH=(double)pixH/(double)ppiH;

	pagesWide=ceil(rW/pW);
	pagesHigh=ceil(rH/pH);

	if (pagesWide==0) { pagesWide++; }
	if (pagesHigh==0) { pagesHigh++; }

	pages=pagesHigh*pagesWide;
*/
	return ((page>0)&&(page <= this->pages));
};

bool BOLTReport::OnBeginDocument(int startPage, int endPage)
{
	wxPrintout::OnBeginDocument(1,pages);
	return true;
};

void BOLTReport::OnEndDocument()
{
	wxPrintout::OnEndDocument();
}


bool BOLTReport::OnPrintPage(int page)
{
//The thing here is - 
	// depending on the page number and page size
	//we set up the where rect to position the page we want in the
	//0,0-wide,hi area
	//draw report determine if a query should be drawn
	
	double rW,rH;

	rW=this->runner->db->GetFValue("reportLayouts","width",this->reportId);
	rH=this->runner->db->GetFValue("reportLayouts","height",this->reportId);
	
	int PPIh,PPIw;
	this->GetPPIPrinter(&PPIh,&PPIw);
	this->runner->UsePPI=PPIh;
	int pixW,pixH;
	GetPageSizePixels(&pixW,&pixH);

	wxCoord dX,dY,dH,dW;
	dX=0 - (((page-1) % pagesWide) * pW *PPIw);
	dY=0 - ((ceil((double)page /(double)pagesWide)-1) * pH *PPIh );
//	dX=0 - (((page-1) % pagesWide) * pixW);
//	dY=0 - ceil((floor((double)page /(double)pagesWide)-1) * (double)pixH);
	dW=ceil(rW * (double)PPIw);
	dH=ceil(rH * (double)PPIh);

	wxRect dRect(dX,dY,dW,dH);
//	wxRect dRect(dX,dY,pixW,pixH);	
	runner->DrawReport(reportId,*GetDC(),dRect,this->reportPage);
	GetDC()->EndPage();
	return true;
};

void BOLTReport::GetPageInfo(int *minPage, int *maxPage, 
	int *selPageFrom, int *selPageTo)
{
	*minPage=1;
	*maxPage=100;
	*selPageFrom=1;
	*selPageTo=100;
};

void BOLTReport::PrintSetup()
{
//	wxPrintout::PrintSetup();
//	this->tBitmap=tBitmap;
};

BOLTReport::~BOLTReport(){
	wxPrintout::OnEndPrinting();
//	if (tBitmap) safe_delete(tBitmap);
};

void BOLTReport::OnPreparePrinting()
{

	int t;

	GetPPIScreen(&(runner->ScreenPPI),&t); //not that it should matter
	if (runner->ScreenPPI!=t)
	{ LOG_ERROR("Report Runner - Programmer Error - X!=Y ScreenPPI"); }
	GetPPIPrinter(&(runner->UsePPI),&t);
	if (runner->UsePPI!=t)
	{ LOG_ERROR("Report Runner - Programmer Error - X!=Y PrinterPPI"); }

	int pixW,pixH;

	double rW,rH;

	rW=this->runner->db->GetFValue("reportLayouts","width",runner->recordId);
	rH=this->runner->db->GetFValue("reportLayouts","height",runner->recordId);

	int ppiW,ppiH;
	GetPageSizePixels(&pixW,&pixH);
	GetPPIPrinter(&ppiW,&ppiH);

	pW=(double)pixW/(double)ppiW;
	pH=(double)pixH/(double)ppiH;

	pagesWide=ceil(rW/pW);
	pagesHigh=ceil(rH/pH);

	if (pagesWide==0) { pagesWide++; }
	if (pagesHigh==0) { pagesHigh++; }

	this->pages=pagesHigh*pagesWide;
//	wxPrintout::OnPreparePrinting();
}